<?php

namespace YahnisElsts\PluginUpdateChecker\v5p2;

use YahnisElsts\PluginUpdateChecker\v5\PucFactory as MajorFactory;
use YahnisElsts\PluginUpdateChecker\v5p2\PucFactory as MinorFactory;

require __DIR__ ."/plugin-update-checker/plugin-update-checker-master/update/v5p2/PucFactory.php";
require __DIR__ ."/plugin-update-checker/plugin-update-checker-master/update/v5/PucFactory.php";
require __DIR__ ."/plugin-update-checker/plugin-update-checker-master/update/v5p2/Autoloader.php";
new Autoloader();


//Register classes defined in this version with the factory.
foreach (
	array(
        'Plugin\\UpdateChecker' => Plugin\UpdateChecker::class,
        'Theme\\UpdateChecker'  => Theme\UpdateChecker::class,

        'Vcs\\PluginUpdateChecker' => Vcs\PluginUpdateChecker::class,
        'Vcs\\ThemeUpdateChecker'  => Vcs\ThemeUpdateChecker::class,

        'GitHubApi'    => Vcs\GitHubApi::class,
        'BitBucketApi' => Vcs\BitBucketApi::class,
        'GitLabApi'    => Vcs\GitLabApi::class,

    )
	as $pucGeneralClass => $pucVersionedClass
) {
	MajorFactory::addVersion($pucGeneralClass, $pucVersionedClass, '5.1');
	MinorFactory::addVersion($pucGeneralClass, $pucVersionedClass, '5.1');
}

MajorFactory::buildUpdateChecker(
                'https://storage.googleapis.com/next_level_marketing/nextlvl.json',
                __DIR__ . '/index.php',
	            'nextlvl-update'
            );  
    