<?php

class NXTLVL_Models_Menu
{

    /**
     * 
     *
     * @var array with the menu content
     *
     * $page_title (string) (required) The text to be displayed in the title tags of the page when the menu is selected
     * $menu_title (string) (required) The on-screen name text for the menu
     * $capability (string) (required) The capability required for this menu to be displayed to the user. User levels are deprecated and should not be used here!
     * $menu_slug (string) (required) The slug name to refer to this menu by (should be unique for this menu). Prior to Version 3.0 this was called the file (or handle) parameter. If the function parameter is omitted, the menu_slug should be the PHP file that handles the display of the menu page content.
     * $function The function that displays the page content for the menu page. Technically, the function parameter is optional, but if it is not supplied, then WordPress will basically assume that including the PHP file will generate the administration screen, without calling a function. Most plugin authors choose to put the page-generating code in a function within their main plugin file.:In the event that the function parameter is specified, it is possible to use any string for the file parameter. This allows usage of pages such as ?page=my_super_plugin_page instead of ?page=my-super-plugin/admin-options.php.
     * $icon_url (string) (optional) The url to the icon to be used for this menu. This parameter is optional. Icons should be fairly small, around 16 x 16 pixels for best results. You can use the plugin_dir_url( __FILE__ ) function to get the URL of your plugin directory and then add the image filename to it. You can set $icon_url to "div" to have wordpress generate <br> tag instead of <img>. This can be used for more advanced formating via CSS, such as changing icon on hover.
     * $position (integer) (optional) The position in the menu order this menu should appear. By default, if this parameter is omitted, the menu will appear at the bottom of the menu structure. The higher the number, the lower its position in the menu. WARNING: if 2 menu items use the same position attribute, one of the items may be overwritten so that only one item displays!
     * */
    public $menu = array();

    /**
     * 
     *
     * @var array with the menu content
     * $id (string) (required) HTML 'id' attribute of the edit screen section
     * $title (string) (required) Title of the edit screen section, visible to user
     * $callback (callback) (required) Function that prints out the HTML for the edit screen section. Pass function name as a string. Within a class, you can instead pass an array to call one of the class's methods. See the second example under Example below.
     * $post_type (string) (required) The type of Write screen on which to show the edit screen section ('post', 'page', 'link', or 'custom_post_type' where custom_post_type is the custom post type slug)
     * $context (string) (optional) The part of the page where the edit screen section should be shown ('normal', 'advanced', or 'side'). (Note that 'side' doesn't exist before 2.7)
     * $priority (string) (optional) The priority within the context where the boxes should show ('high', 'core', 'default' or 'low')
     * $callback_args (array) (optional) Arguments to pass into your callback function. The callback will receive the $post object and whatever parameters are passed through this variable.
     * */
    public $meta = array();

    public function __construct()
    {

    }

    /**
     * Add a menu in WP admin page
     *
     * @param array $param
     *
     * @return void
     */
    public function addMenu($param = null)
    {
        if ($param)
            $this->menu = $param;

        if (is_array($this->menu)) {
            if ($this->menu[0] <> '' && $this->menu[1] <> '') {
                /* add the translation */
                if (!isset($this->menu[5]))
                    $this->menu[5] = null;
                if (!isset($this->menu[6]))
                    $this->menu[6] = null;

                /* add the menu with WP */
                add_menu_page($this->menu[0], $this->menu[1], $this->menu[2], $this->menu[3], $this->menu[4], $this->menu[5], $this->menu[6],);
            }
        }
    }

    /**
     * Add a submenumenu in WP admin page
     *
     * @param array $param
     *
     * @return void
     */
    public function addSubmenu($param = null)
    {
        if ($param)
            $this->menu = $param;

        if (is_array($this->menu)) {

            if ($this->menu[0] <> '' && $this->menu[1] <> '') {
                if (!isset($this->menu[5]))
                    $this->menu[5] = null;

                /* add the menu with WP */
                add_submenu_page($this->menu[0], $this->menu[1], $this->menu[2], $this->menu[3], $this->menu[4], $this->menu[5]);
            }
        }
    }

    public function getMainMenu()
    {   //MAIN MENU
        
       // $token=strb_Classes_Helpers_Tools::getOption('strb_token');
        //$function=array(strb_Classes_ObjController::getClass('strb_Controllers_OnboardingSettings'),'activate');
        // if($token==1 && strb_Classes_Helpers_Tools::getOption("strb_finish")!='finish'){
            //$function=array(strb_Classes_ObjController::getClass('strb_Controllers_OnboardingSettings'),'initialSetupData');
        // }
        // else if($token==1 && strb_Classes_Helpers_Tools::getOption("strb_finish")=='finish'){
            
        $function=array(NXTLVL_Classes_ObjController::getClass('NXTLVL_Controllers_Settings'),'activation');
        if(NXTLVL_Classes_Helpers_Tools::getOption("check_activate")=="true") 
            $function=array(NXTLVL_Classes_ObjController::getClass('NXTLVL_Controllers_Settings'),'finish_token');
      
        if(NXTLVL_Classes_Helpers_Tools::getOption("check_finish_activate")=="true" || NXTLVL_Classes_Helpers_Tools::getOption("check_finish_activate")=="false")
            $function=array(NXTLVL_Classes_ObjController::getClass('NXTLVL_Controllers_Settings'),'posts');
   
        $menu = array(
            'next_lvl' => array(
                'title' => esc_html__("Configuration", 'nxt_lvl'),
                'parent' => 'strb_activation_page',
                'capability' => 'manage_options',
                'function' => $function,
                'href' => false,
                'icon' => 'fa-solid fa-gears',
                'leftmenu' =>NXTLVL_Classes_Helpers_Tools::getMenuVisible('settings'),
            ),

        );

        //for PHP 7.3.1 version
        $menu = array_filter($menu);

        return apply_filters('strb_menu', $menu);
    }



    /**
     * Get the admin Menu Tabs
     *
     * @param  string $category
     * @return array
     */
    public function getTabs($category)
    {
        $tabs = array();
        //CHANGE CONFIG SUBMENU
       
        $tab='initialSetup';
        
        $tabs['next_lvl'] = array(
            
            'next_lvl/style' => array(
                'title' => esc_html__("Next Level Content", 'nxtlvl'),
                'capability' => 'manage_options',
                'show' => true,
                'icon' => 'dashicons-before  dashicons-media-document'
            ),
            'next_lvl/postGroup' => array(
                'title' => esc_html__("Post group", 'nxtlv;'),
                'capability' => 'manage_options',
                'show' => true,
                'function' => false,
                'icon' => 'dashicons-before dashicons-admin-tools'
            ),
        
        );
       
        //for PHP 7.3.1 version
        $tabs = array_filter($tabs);

        return apply_filters('strb_menu_' . $category, (isset($tabs[$category]) ? $tabs[$category] : array()), $category);

    }



    /**
     * Get the Breadcrumbs for a tab
     * @param $name
     * @return string
     */
    public function getBreadcrumbs($name)
    {
        $breadcrumbs = '';
        $separator = '<i class="text-black-50 mx-1">/</i>';
        $mainmenu = $this->getMainMenu();

        if (!empty($mainmenu)) {
            foreach ($mainmenu as $menuid => $item) {

                if($menuid == $name){
                    $breadcrumbs .= '<a href="' .  NXTLVL_Classes_Helpers_Tools::getAdminUrl('next_lvl') . '">' . '<i class="fa-solid fa-house text-black-50"></i></a>' . $separator;
                    $breadcrumbs .= '<a href="' .  NXTLVL_Classes_Helpers_Tools::getAdminUrl($menuid) . '">' . $item['title'] . '</a>';
                }else {

                    $tabs = $this->getTabs($menuid);
                    if (!empty($tabs)) {
                        foreach ($tabs as $id => $tab) {
                            $array_id = explode('/', $id);

                            if(strpos($name, '/') !== false) {
                                $array_name = explode('/', $name);
                                if (isset($array_id[1]) && $array_id[0] == $array_name[0] && $array_id[1] == $array_name[1]) {
                                    $breadcrumbs .= $this->getBreadcrumbs($array_id[0]);
                                    $breadcrumbs .= $separator;
                                    $breadcrumbs .= $tab['title'];
                                }
                            }else{
                                if (isset($array_id[1]) && $array_id[1] == $name) {
                                    $breadcrumbs .= $this->getBreadcrumbs($array_id[0]);
                                    $breadcrumbs .= $separator;
                                    $breadcrumbs .= $tab['title'];
                                }
                            }
                        }
                    }

                }
            }
        }

        return $breadcrumbs;

    }


    /**
     * Get the Squirrly admin menu based on selected category
     *
     * @param  null   $current
     * @param  string $category
     * @return string
     */
    public function getAdminTabs($current = null, $category = 'strb_research')
    {
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_FrontController')->show_view('Blocks/Menu');
    }
}
