<?php

/**
 * Class User
 *
 * $data = get_user_meta($user->ID, 'NXTLVL_data', true);
 * $data = json_decode($data, true);
 * $user = NXTLVL_Classes_ObjController::getDomain('NXTLVL_Models_Domain_User', $data );
 * echo $user->bio;   >  getBio  > _bio
 * print_r($user->toArray());
 * echo $user->theme->path;
 *
 */

 
class NXTLVL_Models_JSONDataModel extends NXTLVL_Models_Abstract_Domain
{

	protected $data_array=array();

    public function setData($key,$data)
	{ 
	  if(!empty($data))
      $this->data_array[$key] = $data;
	}

	public function getData($key)
	{ 
	if(!array_key_exists($key, $this->data_array))
		return null;
	return $this->data_array[$key];
	}

	public function echoData($key)
	{ 
	  if(empty($this->data_array[$key])) {echo '';return;}
	  echo $this->data_array[$key];
	}

	public function toArray()
	{
		return $this->data_array;
	}

	public function toMysql(){
		
		if(isset($this->data_array)) return wp_json_encode($this->data_array);
		return '';
	}

	public function loadUserDataByIDAndDB($user_id,$database_variable)
	{
		$user_data = get_user_meta($user_id,$database_variable,true);
		$user_decoded = array();
		try{
			if(isset($user_data)) 
			 $user_decoded = json_decode($user_data,true);
	}catch(Exception $e)
	{
		echo $e->message;
	}

	

	if(!empty($user_decoded))
	 foreach($user_decoded as $i=>$val)
	 {
		$this->setData($i,$val);
	 }


	}


	

}
