<?php
defined('ABSPATH') || die('Cheatin\' uh?');

/**
 * Set the ajax action and call for wordpress
 */
class NXTLVL_Classes_ActionController extends NXTLVL_Classes_FrontController
{

    /**
     * All Actions
     * @var array with all form and ajax actions 
     */
    var $actions = array();

    public function getActionsList()
    {
        return array(
            array(
                'name' => 'NXTLVL_Controllers_Settings',
                'actions' => array(
                    'action' => array(
                        
                        'nxt_ajax_check_token',
                        'nxt_ajax_validate_token',
                        'nxt_ajax_display_all_posts',
                        'nxt_ajax_display_specific_posts',
                        'nxt_ajax_display_posts',
                        'nxt_ajax_display_pages',
                        'nxt_ajax_display_all_posts',
                        'nxt_change_post_type',
                        'nxt_make_new_post',
                        'nxt_open_meta_form',
                        'nxt_update_post_meta',
                        'nxt_bin_meta_post',
                        'nxt_aprove_post',
                        'nxt_remove_post',
                        'nxt_set_post_dates',
                       
                        'sq_advanced_install',
                        
                    ),
                ),
                'active' => '1',
            ),
       
            array(
                'name' => 'STRB_Controllers_Backup',
                'actions' => array(
                    'action' => array(
                        'strb_settings_backup',
                    ),
                ),
                'active' => '1',
            ),
        );
    }

    /**
     * The hookAjax is loaded as custom hook in hookController class
     *
     * @return void
     */
    public function hookInit()
    {
        /* Only if ajax */
        if (NXTLVL_Classes_Helpers_Tools::isAjax()) {
            $this->getActions();
        }
    }

	/**
	 * The hookHead is loaded as admin hook in hookController class for script load
	 * Is needed for security check as nonce
	 *
	 * @return void
	 */
    public function hookHead() {
       
        echo '<script>
                  var sqQuery = {
                    "adminurl": "' . admin_url() . '",
                    "ajaxurl": "' . admin_url('admin-ajax.php') . '",
                    "adminposturl": "' . admin_url('post.php') . '",
                    "adminlisturl": "' . admin_url('edit.php') . '",
                    "nonce": "' . wp_create_nonce(_NXTLVL_NONCE_ID_) . '"
                  }
              </script>';
       
    }

    public function hookFronthead() {
        if (NXTLVL_Classes_Helpers_Tools::isFrontAdmin()) {
            echo '<script>
                  var sqQuery = {
                    "adminurl": "' . admin_url() . '",
                    "ajaxurl": "' . admin_url('admin-ajax.php') . '",
                    "nonce": "' . wp_create_nonce(_NXTLVL_NONCE_ID_) . '"
                  }
              </script>';

            //   echo '<script type="application/ld+json">
            //   var $schema={
            //       "@context": "' . admin_url() . '",
            //       "name": "local Boss",
               
            //   }
            //   </script>';
        }
    }


    /**
     * The hookSubmit is loaded when action si posted
     *
     * @return void
     */
    public function hookMenu()
    {
        /* Only if post */
        if (!NXTLVL_Classes_Helpers_Tools::isAjax()) {
            $this->getActions();
        }
    }

    /**
     * Get all actions from config.json in core directory and add them in the WP
     */
    public function getActions()
    {

        if (!is_admin()) {
            return;
        }

        $this->actions = array();
        $cur_action = NXTLVL_Classes_Helpers_Tools::getValue('action');
        $http_referer = NXTLVL_Classes_Helpers_Tools::getValue('_wp_http_referer');
        $strb_nonce = NXTLVL_Classes_Helpers_Tools::getValue('strb_nonce');

        //Let only the logged users to access the actions
        if ($cur_action <> '' && $strb_nonce <> '') {

            //load the actions list for each class
            $actions = $this->getActionsList();

            if(!empty($actions)) {
                foreach ($actions as $block) {
                    if (isset($block['active']) && $block['active'] == 1) {
                        /* if there is a single action */
                        if (isset($block['actions']['action']))
                            /* if there are more actions for the current block */
                        if (!is_array($block['actions']['action'])) {
                            /* add the action in the actions array */
                            if ($block['actions']['action'] == $cur_action) {
                                $this->actions[] = array('class' => $block['name']);
                            }
                        } else {
                            /* if there are more actions for the current block */
                            foreach ($block['actions']['action'] as $action) {
                                /* add the actions in the actions array */
                                if ($action == $cur_action) {
                                    $this->actions[] = array('class' => $block['name']);
                                }
                            }
                        }
                    }
                }
            }

            //If there is an action found in the config.js file
            if (!empty($this->actions)) {

                /* add the actions in WP */
                foreach ($this->actions as $actions) {
                    if (NXTLVL_Classes_Helpers_Tools::isAjax() && !$http_referer) {
                        check_ajax_referer(_NXTLVL_NONCE_ID_, 'strb_nonce');
                        add_action('wp_ajax_' . $cur_action, array(NXTLVL_Classes_ObjController::getClass($actions['class']), 'action'));
                    } else {
                        check_admin_referer($cur_action, 'strb_nonce');

                        NXTLVL_Classes_ObjController::getClass($actions['class'])->action();
                    }
                }
            }
        }

    }

}
