<?php

/**
 * Class User
 *
 */
class NXTLVL_Models_Domain_User extends SQP_Models_Abstract_Domain
{

    protected $_ID;
    protected $_display_name;
    protected $_user_nicename;
    protected $_user_login;
    protected $_theme;
    protected $_bio;
	protected $_user_theme;
	/**
	 * Call function   get+Ucase(var)
	 * @return string
	 */
	public function getBio(){
		if(!isset($this->_bio)){
			$this->_bio = NXTLVL_Classes_Helpers_Sanitize::normalizeChars($this->_bio);
		}

		return $this->_bio;
	}

	public function getTheme(){
		$this->_theme = NXTLVL_Classes_ObjController::getDomain('NXTLVL_Models_Domain_Theme', $this->_theme);

		return $this->_theme;
	}

	public function toArray(){
		return array(
			'id' => $this->ID,
			'theme' => $this->theme,
			'bio' => $this->bio,
		);
	}

	public function toMysql(){
		return wp_json_encode(array(
			'theme' => $this->theme->toArray(),
			'bio' => $this->bio,
		));
	}

}
