<?php
defined('ABSPATH') || die('Cheatin\' uh?');

class NXTLVL_Controllers_Settings extends NXTLVL_Classes_FrontController {
  
    public function init()
    { 
        // $tabs = preg_replace("/[^a-zA-Z0-9]/", "", NXTLVL_Classes_Helpers_Tools::getValue('tab','theme'));   
        // $this->show_view('settings/' .'activation');
    }
    
    public function activation(){
        $tabb = preg_replace("/[^a-zA-Z0-9]/", "", NXTLVL_Classes_Helpers_Tools::getValue('tab','activation'));
        $this->show_view('Settings/' . esc_attr(ucfirst($tabb)));
    }

    public function posts(){
        $tabb = preg_replace("/[^a-zA-Z0-9]/", "", NXTLVL_Classes_Helpers_Tools::getValue('tab','style'));
        $this->show_view('Settings/' . esc_attr(ucfirst($tabb)));
    }    
    public function finish_token(){
        $tab = preg_replace("/[^a-zA-Z0-9]/", "", NXTLVL_Classes_Helpers_Tools::getValue('tab','activationFinish'));
        $this->show_view('Settings/' . esc_attr(ucfirst($tab)));
    }    

    public static function get_and_save_content_into_posts(){
        $token=NXTLVL_Classes_Helpers_Tools::getOption('token_res');
        $code=NXTLVL_Classes_Helpers_Tools::getOption('code_res');
        $acount_id=NXTLVL_Classes_Helpers_Tools::getOption('account_id');
            
        $argsCheck = array(
            'method'      => 'POST',  
            'timeout'     => 50,
            'redirection' => 5,
            'httpversion' => '1.0',
            'blocking'    => true,
            'headers'     =>array('Content-Type' => 'application/json','x-authorization'=>'ZbHACrqv3vba'),
            'body' => wp_json_encode(array(
                        "token"=> $token,
                        "token_code"=> $code,
                        "account_id"=> $acount_id,
                    )),
            'cookies' => array());

            error_reporting(E_ERROR | E_PARSE);
            $inputJSONCheck = wp_remote_post("https://app.nextlevelmarketing.ai/api/pub/articles/to_publish",$argsCheck);
            $apiBodyCheck  = json_decode($inputJSONCheck['body']);
            
            //print_r( $apiBodyCheck );
            //**Get each post body    
                    
            foreach($apiBodyCheck->payload as $payload){
                   //print_r($payload);
                    $postBody = array(
                        'method'      => 'POST',  
                        'timeout'     => 50,
                        'redirection' => 5,
                        'httpversion' => '1.0',
                        'blocking'    => true,
                        'headers'     => array('Content-Type' => 'application/json','x-authorization'=>'ZbHACrqv3vba'),
                        'body'        => wp_json_encode(array(
                        "article_id"  => $payload->aid,
                        "authorization" => $payload->authorization,
                        )),
                        'cookies' => array()
                    );
               
                    error_reporting(E_ERROR | E_PARSE);
                    $body = wp_remote_post("https://app.nextlevelmarketing.ai/api/pub/articles/get",$postBody);    
                    $data_result = json_decode($body['body']);
                 
                    //print_r($data_result);
                    //**Insert post
                
                    $aid=(string)$data_result->payload[0]->aid;
                    $arr=(string)NXTLVL_Classes_Helpers_Tools::getOption("df");
                    
                    if(is_int(strpos($arr,$aid))==false){
                        $old=$arr;
                        $new=$aid;
                        $new.=$old;
                        NXTLVL_Classes_Helpers_Tools::saveOptions("df",$new);
                   
                        $my_post = array(
                                'post_title'    => $data_result->payload[0]->title,
                                'post_content'  => $data_result->payload[0]->body,
                                'post_author'   => 1,
                                'post_status'   => 'draft',
                                'post_type'     => 'post',
                                'meta_input'    => array('nextLvl'=>'nextLvlai','aid'=>$aid),  
                        );    
                     
                        $postId=wp_insert_post( $my_post );
                        
                        if(!is_wp_error($postId)){
                          }else{
                            echo $postId->get_error_message();
                        }
                       
                        update_post_meta($postId,'_sq_keywords',$data_result->payload[0]->keyword);
                        update_post_meta($postId,'_sq_title',$data_result->payload[0]->title);
                        update_post_meta($postId,'_sq_description',$data_result->payload[0]->meta_description);
                        update_post_meta($postId, 'nextlvl_post',"nxtlvl");
                        update_post_meta($postId, 'aid',$aid);
                        update_post_meta($postId,'authorization',$payload->authorization);

                        $args = array();     
                        $args['keyword'] = $data_result->payload[0]->keyword;
                        if(class_exists('SQ_Classes_ObjController'))
                        SQ_Classes_RemoteController::addBriefcaseKeyword($args);
                    
                    }
            }
    }
    
    //**Get post types */
    public static function get_posts(){
        $types = get_post_types(); 
        $specificPosts[]="post";
       
        if(NXTLVL_Classes_Helpers_Tools::getOption('posts-check')!=null){
            foreach ($types as $type) {
                    $specificPosts[]=$type;
                }
        } 

        if (isset($_GET['paged']))
            $paged = $_GET['paged'];
        else $paged=1;
      
        $args = array(
                'post_type'=> $specificPosts,
                'post_status' => ['draft','publish','future'],
                'posts_per_page' => 8,
                'meta_key'=>'nextLvl',
                'meta_value'=>'nextLvlai',
                'paged' => $paged
        );
        $postslist = new WP_Query( $args );
        
        return $postslist;
    }

    public static function get_sched_posts(){
        $types = get_post_types(); 
        $specificPosts[]=["post"];
   
        // if(NXTLVL_Classes_Helpers_Tools::getOption('posts-check')!=null){
        //     foreach ($types as $type) {
        //         if(in_array($type,NXTLVL_Classes_Helpers_Tools::getOption('posts-check'))) {
        //             $specificPosts[]=$type;
        //         }}
        // } 
        if (isset($_GET['paged']))
            $paged = $_GET['paged'];
        else $paged=1;
    
        $args = array(
                'post_type' =>$types,
                'post_status' => ['draft','future'],
                'posts_per_page' => 8,
                'meta_key'=>'schedule_post',
                'paged' => $paged
                );
        $postslist = new WP_Query( $args );
        
        return $postslist;
    }

    /**
     * Called when Post action is triggered
     *
     * @return void
     */
    public function action() {
        parent::action();
        switch (NXTLVL_Classes_Helpers_Tools::getValue('action')) {        
          
            case 'nxt_ajax_check_token':
                if (!NXTLVL_Classes_Helpers_Tools::userCan('manage_options')) {
                    return;
                }
                $token=NXTLVL_Classes_Helpers_Tools::getValue('token');
                $postBody = array(
                    'method'      => 'POST',  
                    'timeout'     => 50,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking'    => true,
                    'headers'     =>array('Content-Type' => 'application/json','x-authorization'=>'ZbHACrqv3vba'),
                    'body'        => wp_json_encode(array(
                        "token"=>$token
                    )),
                    'cookies' => array()
                );
                error_reporting(E_ERROR | E_PARSE);

                $body = wp_remote_post("https://app.nextlevelmarketing.ai/api/connection/connect_account/1",$postBody);
                $decoded=json_decode($body['body'],true);

                 if($decoded['payload']!=""){
                     $code_res= $decoded['payload']['code'];
                     $token_res= $decoded['payload']['token'];
                     $acount_id=$decoded['payload']['account_id'];

                     NXTLVL_Classes_Helpers_Tools::saveOptions("code_res",$code_res);
                     NXTLVL_Classes_Helpers_Tools::saveOptions("token_res",$token_res);
                     NXTLVL_Classes_Helpers_Tools::saveOptions("account_id",$acount_id);
                }
                if($decoded['ok']=='true')
                    NXTLVL_Classes_Helpers_Tools::saveOptions("check_activate","true");
                
                wp_send_json($decoded['ok']);
            break;
                    
            case 'nxt_ajax_validate_token':
                if (!NXTLVL_Classes_Helpers_Tools::userCan('manage_options')) {
                    return;
                }
                $registerCode = array(
                        'method'      => 'POST',  
                        'timeout'     => 50,
                        'redirection' => 5,
                        'httpversion' => '1.0',
                        'blocking'    => true,
                        'headers'     =>array('Content-Type' => 'application/json','x-authorization'=>'ZbHACrqv3vba'),
                        'body' => wp_json_encode(array(
                                "token"=>NXTLVL_Classes_Helpers_Tools::getOption('token_res'),
                                "code"=>NXTLVL_Classes_Helpers_Tools::getOption('code_res')
                        )),
                        'cookies' => array()
                );
                $register_body = wp_remote_post("https://app.nextlevelmarketing.ai/api/connection/register_code",$registerCode);
                $decoded_register_body=json_decode( $register_body['body'],true);

                if($decoded_register_body['ok']=='true')
                    NXTLVL_Classes_Helpers_Tools::saveOptions("check_finish_activate","true");
                
                wp_send_json($decoded_register_body['ok']);
            break;

            case 'nxt_change_post_type':
                if (!NXTLVL_Classes_Helpers_Tools::userCan('manage_options')) {
                    return;
                }
                $post_type=NXTLVL_Classes_Helpers_Tools::getValue('postType');
                $post_ID=NXTLVL_Classes_Helpers_Tools::getValue('post_id');

                update_post_meta( $post_ID, "postType",$post_type);
                //NXTLVL_Classes_Helpers_Tools::saveOptions("postType",$post_type);
                $my_post=get_post( $post_ID );
                $my_post->post_status="publish";
                $list = strtr(trim(get_post_meta( $post_ID, '_sq_keywords',true)), ' ', '-');
                $my_post->post_name=$list;
                wp_update_post( $my_post );
                set_post_type( $post_ID, $post_type);
                wp_send_json($post_type);
            break;

            case 'nxt_open_meta_form':
                if (!NXTLVL_Classes_Helpers_Tools::userCan('manage_options')) {
                    return;
                }
                $id = NXTLVL_Classes_Helpers_Tools::getValue('post_id');
                $re = NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->get_meta_data($id);
                wp_send_json($re);
            break;

            case 'nxt_update_post_meta':
                if (!NXTLVL_Classes_Helpers_Tools::userCan('manage_options')) {
                    return;
                }
                $id = NXTLVL_Classes_Helpers_Tools::getValue('id');
                $newTitle = NXTLVL_Classes_Helpers_Tools::getValue('title');
                $newMetaTitle = NXTLVL_Classes_Helpers_Tools::getValue('meta_title');
                $newDescription = NXTLVL_Classes_Helpers_Tools::getValue('description');
                $keywords = NXTLVL_Classes_Helpers_Tools::getValue('keywords');

                $autorId = NXTLVL_Classes_Helpers_Tools::getValue('authorId');
                $postType = NXTLVL_Classes_Helpers_Tools::getValue('postType');
                $postCat = NXTLVL_Classes_Helpers_Tools::getValue('postCat');

                $category[]=get_cat_ID( $postCat );

                $args = array(
                    'ID' => $id,
                    'post_title' => $newTitle,
                    'post_author' => $autorId,
                    'post_type' =>  $postType,
                    'post_category' =>$category,
                );
                wp_update_post( $args );

                update_post_meta($id,'_sq_title',$newMetaTitle);
                update_post_meta($id,'_sq_description',$newDescription);
                update_post_meta($id,'_sq_keywords',$keywords);

                //Add keyword to briefcase
                $args = array();     
                  $args['keyword'] = $keywords;
                  SQ_Classes_RemoteController::addBriefcaseKeyword($args);
                wp_send_json("succes");
            break;

            case 'nxt_bin_meta_post':
                if (!NXTLVL_Classes_Helpers_Tools::userCan('manage_options')) {
                    return;
                }
                $binId=NXTLVL_Classes_Helpers_Tools::getValue('bin_id');
                wp_delete_post($binId);
            break;

            //seo install
            case 'sq_advanced_install':
                if (!NXTLVL_Classes_Helpers_Tools::userCan('manage_options')) {
                    return;
                }   
                //check the version
                NXTLVL_Classes_Helpers_Tools::saveOptions("sq_install","true");
                $response = wp_remote_get('https://storage.googleapis.com/squirrly-seo-pack/updates-squirrly-seo-pack.json?rnd=' . mt_rand(1111,9999));
                $data = json_decode( wp_remote_retrieve_body( $response ));
            
                if($data = json_decode( wp_remote_retrieve_body( $response ) )){
                 
                    $rollback =NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_Rollback');
                    $output = $rollback->install(
                        array(
                            'version' => $data->version,
                            'plugin_name' => $data->name,
                            'plugin_slug' => $data->slug,
                            //'package_url' => $data->download_url
                            'package_url' => 'https://downloads.wordpress.org/plugin/squirrly-seo.zip',
                        )
                    );
    
                if(!is_wp_error($output)){
                $rollback->activate($data->slug . '/index.php');}
                }
            break;  
            
            case 'nxt_ajax_display_all_posts':
                $values = array();
                $values=unserialize($_POST['formChecked']);
                parse_str($_POST['formChecked'], $values);
                NXTLVL_Classes_Helpers_Tools::saveOptions("posts-check",$values);
                wp_send_json($values);
            break;

            case 'nxt_aprove_post':
                $id=NXTLVL_Classes_Helpers_Tools::getValue('id');
                update_post_meta( $id, 'schedule_post', "true" );
                wp_send_json($id);
            break;

            case 'nxt_remove_post':
                $id=NXTLVL_Classes_Helpers_Tools::getValue('id');
                delete_post_meta($id,'schedule_post',"true");
                wp_send_json($id);
            break;

            case 'nxt_set_post_dates':
                $days=NXTLVL_Classes_Helpers_Tools::getValue('day');
                $hours=NXTLVL_Classes_Helpers_Tools::getValue('hours');
                $minutes=NXTLVL_Classes_Helpers_Tools::getValue('minutes');
                $time_format=NXTLVL_Classes_Helpers_Tools::getValue('time_format');

                $hours=explode(' ', $hours);
                $minutes=explode(' ', $minutes);
                
                NXTLVL_Classes_Helpers_Tools::saveOptions("week_days",$days);
                NXTLVL_Classes_Helpers_Tools::saveOptions("hours",$hours);
                NXTLVL_Classes_Helpers_Tools::saveOptions("minutes",$minutes);
                NXTLVL_Classes_Helpers_Tools::saveOptions("time_format",$time_format);

                // wp_send_json($minutes);
            break;
        }
    }

    public function set_post_time(){
        $week_days = NXTLVL_Classes_Helpers_Tools::getOption("week_days");
        $week_split= preg_split('/(?=[A-Z])/',$week_days);
        
        $days=["Su","Mo","Tu","We","Th","Fr","Sa"];
        $Days=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];
        $dd=[];
 
        foreach($week_split as $key=>$week_day){
             if($key>0){   
                 $index=array_search($week_day,$days);
                 array_push($dd,$Days[$index]);
             }
        }

        $post_dates=[];
        $hours=NXTLVL_Classes_Helpers_Tools::getOption("hours");
        $minutes=NXTLVL_Classes_Helpers_Tools::getOption("minutes");   
        $time_format= NXTLVL_Classes_Helpers_Tools::getOption("time_format");
        $time_split= preg_split('/[\s]+/',$time_format);
        if($dd!=null){
        foreach($dd as $d){
            foreach($hours as $key=>$hour){
                if($time_split[$key]==="PM"){
                    $hour=$hour+12;
                }
                array_push($post_dates, date('m-d  H:i', strtotime("$d + $hour hours+$minutes[$key] minutes")));
            }
        }
        sort($post_dates);
        return $post_dates;}
    }

    public function schedule_post($post_id,$date){
     
        $my_post=get_post( $post_id );
        $my_post->edit_date = true;
       // $my_post->post_status = 'future';
        
        $my_post->post_date = date('Y-m-d H:i', strtotime("2024-$date"));
       
        wp_update_post( $my_post );
        global $wpdb;
        $status="future";
       // $int_ID=3583;
        $wpdb->get_results("UPDATE `wp_posts` SET `post_status` = 'future' WHERE `ID` = ".$post_id);
        
        $autorization= get_post_meta( $my_post->ID,'authorization',true);
        $aid = get_post_meta( $my_post->ID,'aid',true);
        
        $articlesPublish = array(
            'method'      => 'POST',  
            'timeout'     => 50,
            'redirection' => 5,
            'httpversion' => '1.0',
            'blocking'    => true,
            'headers'     => array('Content-Type' => 'application/json','x-authorization'=>'ZbHACrqv3vba'),
            'body'        => wp_json_encode(array(
            "authorization" => $autorization,
            "article_id"  => $aid,
            "publish_url" => get_permalink($my_post),
            )),
            'cookies' => array()
        );
        $body = wp_remote_post("https://app.nextlevelmarketing.ai/api/pub/articles/publish",$articlesPublish);

    }
   

}