<?php
defined('ABSPATH') || die('Cheatin\' uh?');

class NXTLVL_Controllers_Menu extends NXTLVL_Classes_FrontController
{

    /**
     * Hook the Admin load
     */
    public function hookInit()
    {
         $value=0;
        /* add the plugin menu in admin */
        if (NXTLVL_Classes_Helpers_Tools::userCan('manage_options')) {
            try {
                //check if activated
                if (get_transient('strb_activate') == 1) {
                    // Delete the redirect transient
                    delete_transient('strb_activate');

                    if (NXTLVL_Classes_Helpers_Tools::getOption('strb_api') == '') {
                     
                       //wp_redirect(STRB_Classes_Helpers_Tools::getAdminUrl('strb_activation_page'));
                       wp_redirect(NXTLVL_Classes_Helpers_Tools::getAdminUrl('next_lvl'));
                        //wp_redirect(STRB_Classes_Helpers_Tools::getAdminUrl('strb_settings','initialSetupe'));
                        die();
                    }
                   
                }

                //Add the Squirrly Class in all Squirrly SEO Pages
                add_filter('admin_body_class', array($this, 'addSettingsClass'));

            } catch (Exception $e) {
            }

        }

    }


    /**
     * Creates the Setting menu in Wordpress
     */
    public function hookMenu()
    {
        global $strb_setting_page;

        //Load the Squirrly Menu
        $mainmenu = $this->model->getMainMenu();

        //run compatibility check on Squirrly settings
        if (NXTLVL_Classes_Helpers_Tools::getIsset('page')) {

            //Get current accessed page
            $page = apply_filters('strb_page', NXTLVL_Classes_Helpers_Tools::getValue('page'));

            if (in_array($page, array_keys($mainmenu))) {
                //Set if it's a plugin Settings Page
                $strb_setting_page = true;

            }
        }

        //Check the Dev Kit settings
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_Helpers_DevKit');
    
        //////////////
        
        $this->model->addMenu(
            array(
            apply_filters('strb_menu_name', 'some name'),
            apply_filters('strb_menu_name', 'Next Level Marketing') ,
            'manage_options',
            //'strb_activation_page',
            'next_lvl',
            //'activation',
            null,
            apply_filters('strb_logo', 'dashicons-airplane')
            )
        );
    

        if (!empty($mainmenu)) {
            foreach ($mainmenu as $name => $item) {

                //Add the page
                $this->model->addSubmenu(
                    array(
                    $item['parent'],
                    $item['title'],
                    $item['title'],
                    $item['capability'],
                    $name,
                    $item['function'],
                    )
                );

            }

            //Update the external links in the menu
            global $submenu;
            if (!empty($submenu['next_lvl'])) {
                foreach ($submenu['next_lvl'] as &$item) {
                    if (isset($mainmenu[$item[2]]['href']) && $mainmenu[$item[2]]['href']) {
                        if (parse_url($mainmenu[$item[2]]['href'], PHP_URL_HOST) !== parse_url(home_url(), PHP_URL_HOST)) {
                            $item[0] .= '<i class="dashicons dashicons-external" style="font-size:12px;vertical-align:-2px;height:10px;"></i>';
                        }
                        $item[2] = $mainmenu[$item[2]]['href'];
                    }
                }
            }
        }
    }

    /**
     * Add the Squirrly Setttings Class in all Squirrly SEO Pages
     * Used for personal layout
     *
     * @param  $classes
     * @return string
     */
    public function addSettingsClass($classes)
    {
        global $strb_setting_page;

        if (isset($strb_setting_page) && $strb_setting_page) {
            $classes = "$classes starbox-settings";
        }

        return $classes;
    }

    /**
     * Hook the Head
     */
    public function hookHead()
    {
        global $strb_setting_page;



        //Load settings only in the Squirrly Menu
        if (isset($strb_setting_page) && $strb_setting_page) {

            NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('bootstrap-reboot', array('dependencies' => 'jquery'));
            if (is_rtl()) {
                NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('popper', array('dependencies' => 'jquery'));
                NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('bootstrap.rtl', array('dependencies' => 'jquery'));
                NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('rtl', array('dependencies' => 'jquery'));
            } else {
                NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('popper', array('dependencies' => 'jquery'));
                NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('bootstrap', array('dependencies' => 'jquery'));
            }
            NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('bootstrap-select', array('dependencies' => 'jquery'));

            NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('switchery', array('dependencies' => 'jquery'));
            NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('fontawesome', array('dependencies' => 'jquery'));
            NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('global', array('dependencies' => 'jquery'));
            NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('navbar', array('dependencies' => 'jquery'));

            NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('nxtsettings', array('dependencies' => 'jquery'));
            NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('nxtnewsettings', array('dependencies' => 'jquery'));

        }

        //Load the Squirrly Logo on all Dashboard
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia('logo');

    }



}
