<?php
defined('ABSPATH') || die('Cheatin\' uh?');

/**
 * The main class for controllers
 */
class NXTLVL_Classes_FrontController
{

    /**
     * 
     *
     * @var object of the model class 
     */
    public $model;

    /**
     * 
     *
     * @var boolean 
     */
    public $flush = true;

    /**
     * 
     *
     * @var name of the  class 
     */
    private $name;

    public function __construct()
    {
        // Load error class
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_Error');

        /* get the name of the current class */
        $this->name = get_class($this);

        /* load the model and hooks here for wordpress actions to take efect */
        /* create the model and view instances */
        $model_classname = str_replace('Controllers', 'Models', $this->name);
        if (NXTLVL_Classes_ObjController::getClassPath($model_classname)) {
            $this->model = NXTLVL_Classes_ObjController::getClass($model_classname);
        }

        //IMPORTANT TO LOAD HOOKS HERE
        /* check if there is a hook defined in the controller clients class */
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_HookController')->setHooks($this);
        //STRB_Classes_ObjController::getClass('STRB_Classes_HookController')->getShortcodes();
        
        /* Load the Submit Actions Handler */
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_ActionController');
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController');

        // load the abstract classes
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Models_Abstract_Domain');
        // STRB_Classes_ObjController::getClass('STRB_Models_Abstract_Models');
        // STRB_Classes_ObjController::getClass('STRB_Models_Abstract_Seo');
    }

    public function getClass()
    {
        return $this->name;
    }

    /**
     * load sequence of classes
     * Function called usualy when the controller is loaded in WP
     *
     * @return mixed
     */
    public function init()
    {
        $class = NXTLVL_Classes_ObjController::getClassPath($this->name);

        if (!$this->flush) {
            return $this->get_view($class['name']);
        }

        NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->loadMedia($class['name']);
        $this->show_view($class['name']);

    }

    /**
     * Get the view block
     *
     * @param  string $view Class name
     * @return mixed
     */
    public function get_view($view)
    {
        return NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->get_view($view, $this);
    }

       /**
     * Get the view block
     *
     * @param  string $view Class name
     * @return mixed
     */
    // public function getThemeView($user, $value_to_render)
    // {
    //     $view = "Themes/themes_render";
    //     return NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->get_view_with_render($view, $this, $user, $value_to_render );
    // }
    
    // public function getThemeViewImg($user, $value_to_render,$image,$editMode=FALSE)
    // { 
    //     $view = "Themes/themes_render";
    //     return STRB_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->get_view_with_img($view, $this, $user, $value_to_render,$image,$editMode);
    // }



    /**
     * Show the view block
     *
     * @param  string $view Class name
     * @return string the included view file from /view directory
     */
    public function show_view($view)
    {
        $content =  NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->get_view($view, $this);

        //Support for international languages
        if (function_exists('iconv') && NXTLVL_Classes_Helpers_Tools::getOption('strb_non_utf8_support')) {
            if (strpos(get_bloginfo("language"), 'en') === false) {
                $content = iconv('UTF-8', 'UTF-8//IGNORE', $content);
            }
        }

        //echo the file from /view directory
        //already escaped in the view
        //Contains HTML output
        echo $content;
    }
    public function show_viewId($view,$id)
    {
        $content =  NXTLVL_Classes_ObjController::getClass('NXTLVL_Classes_DisplayController')->get_viewId($view,$this,$id);

        //Support for international languages
        if (function_exists('iconv') && NXTLVL_Classes_Helpers_Tools::getOption('strb_non_utf8_support')) {
            if (strpos(get_bloginfo("language"), 'en') === false) {
                $content = iconv('UTF-8', 'UTF-8//IGNORE', $content);
            }
        }

        //echo the file from /view directory
        //already escaped in the view
        //Contains HTML output
        echo $content;
    }

    /**
     * Called as menu callback to show the block
     */
    public function show()
    {
        $this->flush = true;

        echo $this->init();
    }

    /**
     * initialize settings
     * Called from index
     *
     * @return void
     */
    public function runAdmin()
    {
        // show the admin menu and post actions
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Controllers_Menu');
    }

    /**
     * Run fron frontend
     */
    public function runFrontend()
    {
        //Load Frontend only if Squirrly SEO is enabled
        NXTLVL_Classes_ObjController::getClass('NXTLVL_Controllers_Frontend');
    }

    /**
     * first function call for any class
     */
    protected function action()
    { 
    }

    /**
     * This function will load the media in the header for each class
     *
     * @return void
     */
    public function hookHead()
    { 
    }

}
