<?php
defined('ABSPATH') || die('Cheatin\' uh?');

/**
 * The class handles the theme part in WP
 */
class NXTLVL_Classes_DisplayController
{

    private static $cache;

    /**
     * echo the css link from theme css directory
     *
     * @param string $uri    The name of the css file or the entire uri path of the css file
     * @param string $params : trigger, media
     *
     * @return void
     */
    public static function loadMedia($uri = '', $params = array())
    {
        if (NXTLVL_Classes_Helpers_Tools::isAjax()) {
            return;
        }

        if (empty($params)) {
            $params = array('trigger' => false);
        }

        $css_uri = '';
        $js_uri = '';

        if (isset(self::$cache[$uri]))
            return;

        self::$cache[$uri] = true;

        /* if is a custom css file */
        if (strpos($uri, '//') === false) {
            $name = substr(md5($uri), 0, 10);

            if (strpos($uri, '.css') !== false && file_exists(_NXTLVL_ASSETS_DIR_ . 'css/' . strtolower($uri))) {
                $css_uri = _NXTLVL_ASSETS_URL_ . 'css/' . strtolower($uri);
            }
            if (file_exists(_NXTLVL_ASSETS_DIR_ . 'css/' . strtolower($uri) . (NXTLVL_DEBUG ? '' : '.min') . '.css')) {
                $css_uri = _NXTLVL_ASSETS_URL_ . 'css/' . strtolower($uri) . (NXTLVL_DEBUG ? '' : '.min') . '.css';
            }

            if (strpos($uri, '.js') !== false && file_exists(_NXTLVL_ASSETS_DIR_ . 'js/' . strtolower($uri))) {
                $js_uri = _NXTLVL_ASSETS_URL_ . 'js/' . strtolower($uri);
            }
            if (file_exists(_NXTLVL_ASSETS_DIR_ . 'js/' . strtolower($uri) . (NXTLVL_DEBUG ? '' : '.min') . '.js')) {
                $js_uri = _NXTLVL_ASSETS_URL_ . 'js/' . strtolower($uri) . (NXTLVL_DEBUG ? '' : '.min') . '.js';
            }

        } else {

            $name = substr(md5($uri), 0, 10);

            if (strpos($uri, '.css') !== false) {
                $css_uri = $uri;
            } elseif (strpos($uri, '.js') !== false) {
                $js_uri = $uri;
            }

        }


        if ($css_uri <> '') {
            if (!wp_style_is($name)) {
                wp_enqueue_style($name, $css_uri, null, NEXT_LVL, 'all');

                if (is_admin() || (isset($params['trigger']) && $params['trigger'] === true)) { //load CSS for admin or on triggered
                    wp_print_styles(array($name));
                }
            }

        }

        if ($js_uri <> '') {
            if (!wp_script_is($name)) {

                if (!wp_script_is('jquery')) {
                    wp_enqueue_script('jquery');
                    wp_print_scripts(array('jquery'));
                }

                wp_enqueue_script($name, $js_uri, null, NEXT_LVL);

                if (is_admin() || isset($params['trigger']) && $params['trigger'] === true) {
                    wp_print_scripts(array($name));
                }
            }

        }
    }

    /**
     * return the block content from theme directory
     *
     * @param  $block
     * @param  $view
     * @return bool|string
     */
    public function get_view($block, $view)
    {

        try {
            $file = apply_filters('strb_view', _NXTLVL_THEME_DIR_ . $block . '.php', $block);
            if (file_exists($file)) {
                ob_start();
                include $file;
                return ob_get_clean();
            }

        } catch (Exception $e) {
        }

        return false;
    }
    public function get_viewId($block,$id)
    {

        try {
            $file = apply_filters('strb_view', _NXTLVL_THEME_DIR_ . $block . '.php', $block);
            if (file_exists($file)) {
                ob_start();
                $Stb_Id=$id;
                include $file;
                return ob_get_clean();
            }

        } catch (Exception $e) {
        }

        return false;
    }
 

        /**
     * return the block content from theme directory
     *
     * @param  $block
     * @param  $view
     * @return bool|string
     */
    public function get_view_with_render($block, $view, $user, $theme_to_render)
    {

        try {
            $file = apply_filters('strb_view', _NXTLVL_THEME_DIR_ . $block . '.php', $block);

            if (file_exists($file)) {
                ob_start();
                ///$file = 'C:\xampp\htdocs\wordpress\wp-content\plugins\starboxnew/view/Themes/Standard/business1.php';
                $STB_THEME_TO_LOAD = $theme_to_render;
                $STB_USER_TO_LOAD = $user;
                //$STB_IMG_TO_LOAD = $img_to_render;
                include $file;
                return ob_get_clean();
            }

        } catch (Exception $e) {
          
        }

        return false;
    }
    public function get_view_with_img($block, $view, $user, $theme_to_render,$img_to_render,$edit_mode)
    {

        try {
            $file = apply_filters('strb_view', _NXTLVL_THEME_DIR_ . $block . '.php', $block);

            if (file_exists($file)) {
                ob_start();
                ///$file = 'C:\xampp\htdocs\wordpress\wp-content\plugins\starboxnew/view/Themes/Standard/business1.php';
                $STB_THEME_TO_LOAD = $theme_to_render;
                $STB_USER_TO_LOAD = $user;
                $STB_IMG_TO_LOAD = $img_to_render;
                $STB_EDIT_MODE = $edit_mode;
                include $file;
                return ob_get_clean();
            }

        } catch (Exception $e) {
          
        }

        return false;
    }

    public function get_meta_data($post_id){
        try {
            $block="Blocks/EditMetaData";
            $file = apply_filters('strb_view', _NXTLVL_THEME_DIR_ . $block . '.php', $block);

            if (file_exists($file)) {
                ob_start();
                ///$file = 'C:\xampp\htdocs\wordpress\wp-content\plugins\starboxnew/view/Themes/Standard/business1.php';
                $POST_ID = $post_id;
                
                include $file;
                return ob_get_clean();
            }

        } catch (Exception $e) {
          
        }

        return false;
    }

    public function get_edit_user_data($user)
    {

        try {
            $block="Blocks/EditUserData";
            $file=apply_filters('strb_view', _NXTLVL_THEME_DIR_ . $block . '.php', $block);
           // $file = apply_filters('strb_view', _STRB_THEME_DIR_ .'Blocks/EditUserData.php','Blocks/EditUserData');

            if (file_exists($file)) {
                ob_start();
                
               
                $STB_USER_DATA = $user;
                //$STB_IMG_TO_LOAD = $img_to_render;
                include $file;
                return ob_get_clean();
            }

        } catch (Exception $e) {
          
        }

        return false;
    }


}
